<?php
require_once "./config.php";
?>
<!DOCTYPE html>
<html lang="en">
<?php require_once "./head.php"; ?>

<body>
    <?php require_once "./header.php"; ?>

    <!-- Main content -->
    <div class="content">
        <!-- Page header -->
        <div class="page-header">
            <h1 class="page-title"><?php echo $pageTitle; ?></h1>
            <div class="botonera">
                <?php if($user["type"] == 'admin'){ ?>
                <button class="success" id="addBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    New SKU
                </button>
                <?php } ?>
                <select name="agrupar" class="datatable-filter" data-column="agrupar" style="padding: 0 7px;">
                    <option value="month" selected>Group by month</option>
                    <option value="7">Group each 7 days</option>
                    <option value="15">Group each 15 days</option>
                </select>                
                <!-- <button id="importCsvBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="17 8 12 3 7 8"></polyline>
                        <line x1="12" y1="3" x2="12" y2="15"></line>
                    </svg>
                    Import from CSV
                </button>
                <button id="exportCsvBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="7 10 12 15 17 10"></polyline>
                        <line x1="12" y1="15" x2="12" y2="3"></line>
                    </svg>
                    Exportar a CSV
                </button> -->
            </div>
        </div>

        <!-- Table container -->
        <?php
        $filter = "WHERE ";
        if (isset($_GET['filter_category']) and $_GET['filter_category'] != "") {
            $filter .= "category = '" . $_GET['filter_category'] . "' ";
        }
        if ($filter == 'WHERE ') {
            $filter = "";
        }

        generarTabla("SELECT id,created,updated,sku,name,category FROM skus " . $filter . " ORDER BY id ASC", array("Category" => "SELECT DISTINCT(category) FROM skus;")); ?>
    </div>

    <div id="popup-add" class="popup">
        <h3 style="text-align:center;">New</h3>
        <label>SKU:</label>
        <input type="text" id="add-sku" class="form-control" style="width:100%; margin-bottom:10px;">
        <label>Name:</label>
        <input type="text" id="add-name" class="form-control" style="width:100%; margin-bottom:10px;">
        <label>Category:</label>
        <input type="text" id="add-category" class="form-control" style="width:100%; margin-bottom:10px;">
        <div style="display:flex; justify-content:space-between;">
            <button id="btn-save-add">Save</button>
            <button id="btn-cancel-add">Cancel</button>
        </div>
    </div>

    <div id="popup-edit" class="popup">
        <h3 style="text-align:center;">Edit</h3>
        <label>SKU:</label>
        <input type="text" id="edit-sku" class="form-control" style="width:100%; margin-bottom:10px;">
        <label>Name:</label>
        <input type="text" id="edit-name" class="form-control" style="width:100%; margin-bottom:10px;">
        <label>Category:</label>
        <input type="text" id="edit-category" class="form-control" style="width:100%; margin-bottom:10px;">
        <div style="display:flex; justify-content:space-between;">
            <button id="btn-save-edit">Save</button>
            <button id="btn-cancel-edit">Cancel</button>
        </div>
    </div>

    <div id="overlay" class="overlay"></div>

    <script>jQuery(document).ready(function($) {
        $("td.actions").each(function() {
            const $row = $(this).closest("tr");
            const sku = $row.find('td[col="sku"]').text().trim();

            if (sku) {
                const forecastBtn = `
                    <a href="forecast.php?sku=${encodeURIComponent(sku)}&group=month" class="action-btn btn-forecast" title="Ver pronóstico" style="margin-left:5px;" target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <circle cx="11" cy="11" r="8"></circle>
                            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                        </svg>
                    </a>
                `;
                $(this).append(forecastBtn);                
                <?php if($user["type"] != 'admin'){ ?>
                    $(this).html(forecastBtn);
                <?php } ?>
            }
        });
            
        // Cuando el select de agrupación cambia
        $("select[name='agrupar']").on("change", function () {
            var nuevoAgrupar = $(this).val(); // Obtener el nuevo valor seleccionado

            // Recorrer todos los botones con clase .btn-forecast
            $(".btn-forecast").each(function () {
                var href = $(this).attr("href");

                // Si el href contiene forecast.php y tiene un parámetro agrupar
                if (href.includes("forecast.php") && href.includes("group=")) {
                    // Reemplazamos el valor de agrupar con el nuevo valor
                    var nuevoHref = href.replace(/group=[^&]*/, "group=" + nuevoAgrupar);
                    $(this).attr("href", nuevoHref); // Actualizamos el atributo href
                }
            });
        });    
    });</script>
    
    <script>
        jQuery(document).ready(function($) {
            // Crear nuevo
            $("#addBtn").on("click", function() {
                $("#popup-add, #overlay").fadeIn(200);
            });
            $("#btn-cancel-add").on("click", function() {
                $("#popup-add, #overlay").fadeOut(200);
            });
            $("#btn-save-add").on("click", function() {
                const sku = $("#add-sku").val();
                const name = $("#add-name").val();
                const category = $("#add-category").val();

                if (!sku || !category || !name) {
                    alert("Please fill all fields");
                    return;
                }

                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'create_sku',
                        sku: sku,
                        name: name,
                        category: category
                    },
                    success: function(response) {
                        alert("SKU created");
                        location.reload(); // ← refresca la página
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.error("AJAX error:", textStatus, errorThrown);
                        alert("Failed to create record.");
                    }
                });
            });

            // Editar
            window.editRecord = function(id) {
                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'get_sku',
                        id: id,
                    },
                    success: function(response) {
                        try {
                            const record = JSON.parse(response);

                            $("#edit-sku").val(record.sku);
                            $("#edit-name").val(record.name);
                            $("#edit-category").val(record.category);
                            $("#popup-edit").data("record-id", record.id);

                            $("#popup-edit, #overlay").fadeIn(200);
                        } catch (e) {
                            alert("Error parsing record data.");
                            console.error(e);
                        }
                    },
                    error: function() {
                        alert("Failed to fetch record data.");
                    }
                });
            }
            $("#btn-cancel-edit").on("click", () => $("#popup-edit").fadeOut(200));
            $("#btn-save-edit").on("click", function() {
                const recordId = $("#popup-edit").data("record-id");

                const sku = $("#edit-sku").val();
                const name = $("#edit-name").val();
                const category = $("#edit-category").val();

                if (!category || !sku || !name) {
                    alert("Please fill all fields");
                    return;
                }

                $.ajax({ 
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'edit_sku',
                        id: recordId,
                        sku: sku,
                        name: name,
                        category: category
                    },
                    success: function(response) {
                        console.log(response);
                        try {
                            const updated = JSON.parse(response).data;

                            // Actualizar visualmente la fila, tiene que hacer match el query de generarTabla con los nombres regresa el ajax de los campos de la bdd
                            const row = $(`tr[fila="${updated.id}"]`);
                            row.find("td[col]").each(function () {
                                const campo = $(this).attr("col");
                                if (updated[campo] !== undefined) {
                                    $(this).text(updated[campo]);
                                }
                            });
                            
                            var tabla = $('#tabla-dinamica').DataTable();
                            tabla.row(row).invalidate().draw(); // ← fuerza a redibujar la fila correctamente

                            $("#popup-edit").fadeOut(200);
                        } catch (e) {
                            alert("Saved but failed to parse response");
                            console.log(e);
                        }
                    },
                    error: function() {
                        alert("Failed to update record.");
                    }
                });
            });

            // Borrar
            window.deleteRecord = function(id) {
                if (!confirm("Are you sure you want to delete the record with id=" + id + "?")) return;

                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'delete_sku',
                        id: id
                    },
                    success: function(response) {
                        const row = $(`tr[fila="${id}"]`);
                        var tabla = $('#tabla-dinamica').DataTable(); // ← recuperas instancia ya inicializada
                        tabla.row(row).remove().draw();
                        alert("Record deleted successfully.");
                        $("#resultsquery").html($("#resultsquery").html()-1);
                        //alert("Response: " + response);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.error("AJAX error:", textStatus, errorThrown);
                        alert("Failed to delete record, contact support");
                    }
                });
            }

            // Exportar
            $("#exportCsvBtn").on("click", function() {
                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'export_skus_csv'
                    },
                    success: function(data, status, xhr) {
                        // Crear archivo y forzar descarga
                        const filename = 'skus_' + new Date().toISOString().slice(0, 19).replace(/[:T]/g, '-') + '.csv';
                        const blob = new Blob([data], {
                            type: 'text/csv;charset=utf-8;'
                        });

                        const link = document.createElement('a');
                        link.href = URL.createObjectURL(blob);
                        link.download = filename;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    },
                    error: function() {
                        alert("Failed to export CSV.");
                    }
                });
            });
        });
    </script>
    
    <?php require_once "./footer.php"; ?>
    <?php if (isset($alert)) {
        echo '<script>alert(" ' . $alert . ' ")</script>';
    } ?>
</body>

</html>